<?php
// app/Middleware/AuthMiddleware.php

namespace App\Middleware;

use App\Core\JWT;
use App\Core\Request;
use App\Core\Response;

class AuthMiddleware {
    public static function handle() {
        $request = new Request();
        $token = $request->bearerToken();

        if (!$token) {
            Response::unauthorized('Token bulunamadı');
        }

        $payload = JWT::decode($token);

        if (!$payload) {
            Response::unauthorized('Geçersiz veya süresi dolmuş token');
        }

        // Token'dan gelen kullanıcı bilgilerini global değişkene kaydet
        $GLOBALS['auth_user'] = $payload;

        return true;
    }

    public static function user() {
        return $GLOBALS['auth_user'] ?? null;
    }

    public static function id() {
        return $GLOBALS['auth_user']['id'] ?? null;
    }

    public static function role() {
        return $GLOBALS['auth_user']['rol'] ?? null;
    }
}