<?php
// app/Middleware/CsrfMiddleware.php

namespace App\Middleware;

use App\Core\Request;
use App\Core\Response;

class CsrfMiddleware {
    public static function generateToken() {
        if (!isset($_SESSION['csrf_token'])) {
            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
        }
        return $_SESSION['csrf_token'];
    }

    public static function handle() {
        $request = new Request();
        
        if (in_array($request->method(), ['POST', 'PUT', 'DELETE'])) {
            $token = $request->header('X-CSRF-Token') ?? $request->get('csrf_token');
            
            if (!$token || !isset($_SESSION['csrf_token']) || $token !== $_SESSION['csrf_token']) {
                Response::error('CSRF token doğrulaması başarısız', null, 419);
            }
        }

        return true;
    }
}