<?php
// app/Models/Note.php

namespace App\Models;

use App\Core\Database;

class Note {
    private $db;
    private $table = 'notes';

    public function __construct() {
        $this->db = Database::getInstance();
    }

    public function findByCustomer($customerId) {
        $sql = "SELECT n.*, u.ad_soyad as kullanici_adi 
                FROM {$this->table} n 
                LEFT JOIN users u ON n.user_id = u.id 
                WHERE n.customer_id = :customer_id 
                ORDER BY n.created_at DESC";
        return $this->db->fetchAll($sql, ['customer_id' => $customerId]);
    }

    public function findById($id) {
        $sql = "SELECT n.*, u.ad_soyad as kullanici_adi 
                FROM {$this->table} n 
                LEFT JOIN users u ON n.user_id = u.id 
                WHERE n.id = :id";
        return $this->db->fetch($sql, ['id' => $id]);
    }

    public function create($data) {
        return $this->db->insert($this->table, $data);
    }

    public function update($id, $data) {
        return $this->db->update($this->table, $data, 'id = :id', ['id' => $id]);
    }

    public function delete($id) {
        return $this->db->delete($this->table, 'id = :id', ['id' => $id]);
    }

    public function count() {
        return $this->db->count($this->table);
    }

    public function countByCustomer($customerId) {
        return $this->db->count($this->table, 'customer_id = :customer_id', ['customer_id' => $customerId]);
    }
}