<?php
// app/Models/Task.php

namespace App\Models;

use App\Core\Database;

class Task {
    private $db;
    private $table = 'tasks';

    public function __construct() {
        $this->db = Database::getInstance();
    }

    public function findAll() {
        $sql = "SELECT t.*, 
                    u1.ad_soyad as atayan_admin, 
                    u2.ad_soyad as atanan_kullanici,
                    c.ad_soyad as musteri_adi
                FROM {$this->table} t 
                LEFT JOIN users u1 ON t.atayan_admin_id = u1.id 
                LEFT JOIN users u2 ON t.atanmis_kullanici_id = u2.id 
                LEFT JOIN customers c ON t.musteri_id = c.id 
                ORDER BY t.created_at DESC";
        return $this->db->fetchAll($sql);
    }

    public function findById($id) {
        $sql = "SELECT t.*, 
                    u1.ad_soyad as atayan_admin, 
                    u2.ad_soyad as atanan_kullanici,
                    c.ad_soyad as musteri_adi
                FROM {$this->table} t 
                LEFT JOIN users u1 ON t.atayan_admin_id = u1.id 
                LEFT JOIN users u2 ON t.atanmis_kullanici_id = u2.id 
                LEFT JOIN customers c ON t.musteri_id = c.id 
                WHERE t.id = :id";
        return $this->db->fetch($sql, ['id' => $id]);
    }

    public function findByUser($userId) {
        $sql = "SELECT t.*, 
                    u1.ad_soyad as atayan_admin, 
                    c.ad_soyad as musteri_adi
                FROM {$this->table} t 
                LEFT JOIN users u1 ON t.atayan_admin_id = u1.id 
                LEFT JOIN customers c ON t.musteri_id = c.id 
                WHERE t.atanmis_kullanici_id = :user_id 
                ORDER BY t.created_at DESC";
        return $this->db->fetchAll($sql, ['user_id' => $userId]);
    }

    public function create($data) {
        return $this->db->insert($this->table, $data);
    }

    public function update($id, $data) {
        return $this->db->update($this->table, $data, 'id = :id', ['id' => $id]);
    }

    public function delete($id) {
        return $this->db->delete($this->table, 'id = :id', ['id' => $id]);
    }

    public function count() {
        return $this->db->count($this->table);
    }

    public function countByUser($userId) {
        if ($userId === null) {
            return $this->count();
        }
        return $this->db->count($this->table, 'atanmis_kullanici_id = :user_id', ['user_id' => $userId]);
    }

    public function countByStatus($status, $userId = null) {
        if ($userId === null) {
            return $this->db->count($this->table, 'durum = :durum', ['durum' => $status]);
        }
        return $this->db->count($this->table, 'durum = :durum AND atanmis_kullanici_id = :user_id', [
            'durum' => $status,
            'user_id' => $userId
        ]);
    }

    public function findByStatus($status) {
        $sql = "SELECT t.*, u.ad_soyad as atanan_kullanici 
                FROM {$this->table} t 
                LEFT JOIN users u ON t.atanmis_kullanici_id = u.id 
                WHERE t.durum = :durum 
                ORDER BY t.created_at DESC";
        return $this->db->fetchAll($sql, ['durum' => $status]);
    }

    public function findByCustomer($customerId) {
        $sql = "SELECT t.*, u.ad_soyad as atanan_kullanici 
                FROM {$this->table} t 
                LEFT JOIN users u ON t.atanmis_kullanici_id = u.id 
                WHERE t.musteri_id = :customer_id 
                ORDER BY t.created_at DESC";
        return $this->db->fetchAll($sql, ['customer_id' => $customerId]);
    }
}