<?php
// app/Models/User.php

namespace App\Models;

use App\Core\Database;

class User {
    private $db;
    private $table = 'users';

    public function __construct() {
        $this->db = Database::getInstance();
    }

    public function findAll() {
        $sql = "SELECT id, ad_soyad, email, rol, durum, created_at FROM {$this->table} ORDER BY id DESC";
        return $this->db->fetchAll($sql);
    }

    public function findById($id) {
        $sql = "SELECT id, ad_soyad, email, rol, durum, created_at FROM {$this->table} WHERE id = :id";
        return $this->db->fetch($sql, ['id' => $id]);
    }

    public function findByEmail($email) {
        $sql = "SELECT * FROM {$this->table} WHERE email = :email";
        return $this->db->fetch($sql, ['email' => $email]);
    }

    public function create($data) {
        // Şifreyi hashle
        if (isset($data['sifre'])) {
            $data['sifre'] = password_hash($data['sifre'], PASSWORD_BCRYPT);
        }
        
        return $this->db->insert($this->table, $data);
    }

    public function update($id, $data) {
        // Şifre varsa hashle
        if (isset($data['sifre']) && !empty($data['sifre'])) {
            $data['sifre'] = password_hash($data['sifre'], PASSWORD_BCRYPT);
        } else {
            unset($data['sifre']);
        }
        
        return $this->db->update($this->table, $data, 'id = :id', ['id' => $id]);
    }

    public function delete($id) {
        return $this->db->delete($this->table, 'id = :id', ['id' => $id]);
    }

    public function verifyPassword($password, $hash) {
        return password_verify($password, $hash);
    }

    public function count() {
        return $this->db->count($this->table);
    }

    public function countByRole($role) {
        return $this->db->count($this->table, 'rol = :rol', ['rol' => $role]);
    }

    public function countByStatus($status) {
        return $this->db->count($this->table, 'durum = :durum', ['durum' => $status]);
    }
}