<?php
/**
 * backup.php - Otomatik Veritabanı Yedekleme
 * 
 * Kullanım:
 * 1. Tarayıcıda: https://siteniz.com/backup.php?key=GUVENLIK_ANAHTARI
 * 2. cPanel Cron Job ile otomatik: php /home/kullanici/public_html/backup.php GUVENLIK_ANAHTARI
 */

// GÜVENLİK ANAHTARI - Değiştirin!
define('BACKUP_KEY', 'degistir-bu-guvenlik-anahtarini-2024');

// Güvenlik kontrolü
$key = $_GET['key'] ?? $argv[1] ?? '';
if ($key !== BACKUP_KEY) {
    die('Yetkisiz erişim!');
}

// Config yükle
$config = require __DIR__ . '/config.php';
$dbConfig = $config['database'];

// Yedek klasörü
$backupDir = __DIR__ . '/backups';
if (!is_dir($backupDir)) {
    mkdir($backupDir, 0755, true);
}

// Yedek dosya adı
$backupFile = $backupDir . '/crm_backup_' . date('Y-m-d_H-i-s') . '.sql';

try {
    // MySQL dump komutu
    $command = sprintf(
        'mysqldump --user=%s --password=%s --host=%s %s > %s',
        escapeshellarg($dbConfig['username']),
        escapeshellarg($dbConfig['password']),
        escapeshellarg($dbConfig['host']),
        escapeshellarg($dbConfig['database']),
        escapeshellarg($backupFile)
    );
    
    exec($command, $output, $return);
    
    if ($return === 0 && file_exists($backupFile)) {
        $size = round(filesize($backupFile) / 1024, 2);
        echo "✅ Yedekleme başarılı!\n";
        echo "📁 Dosya: " . basename($backupFile) . "\n";
        echo "📊 Boyut: {$size} KB\n";
        
        // 30 günden eski yedekleri sil
        $files = glob($backupDir . '/crm_backup_*.sql');
        $now = time();
        foreach ($files as $file) {
            if ($now - filemtime($file) >= 30 * 24 * 60 * 60) {
                unlink($file);
                echo "🗑️ Eski yedek silindi: " . basename($file) . "\n";
            }
        }
    } else {
        echo "❌ Yedekleme başarısız!\n";
        echo "Hata: mysqldump komutu çalışmadı.\n";
    }
} catch (Exception $e) {
    echo "❌ Hata: " . $e->getMessage() . "\n";
}

echo "\n📅 Tarih: " . date('Y-m-d H:i:s') . "\n";
echo "-----------------------------------\n";
?>

<!--
CRON JOB KURULUMU (cPanel):

1. cPanel → Cron Jobs
2. "Add New Cron Job" tıkla
3. Ayarlar:
   - Common Settings: Once Per Day (Daily)
   - Command: php /home/KULLANICI_ADIN/public_html/backup.php GUVENLIK_ANAHTARI
4. Add New Cron Job

Örnek Komut:
php /home/kullanici/public_html/backup.php degistir-bu-guvenlik-anahtarini-2024

Not: KULLANICI_ADIN ve GUVENLIK_ANAHTARI kısımlarını değiştirin!
-->